/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.repair.utils;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.EventLog;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.pa.persist.PersistenceNotInitializedException;
import com.ibm.hwmca.fw.pa.persist.ProblemPersistenceException;
import com.ibm.hwmca.fw.pa.problem.Problem;
import com.ibm.hwmca.fw.pa.problem.ProblemManager;
import com.ibm.hwmca.fw.pa.problem.TimeProblemFilter;
import com.ibm.hwmca.fw.pa.problem.history.HistoryEntry;
import com.ibm.hwmca.fw.pa.system.PASystem;
import com.ibm.hwmca.fw.rsf.RemoteSupportFacility;
import com.ibm.hwmca.fw.rsf.RsfManager;
import com.ibm.hwmca.fw.rsf.RsfRequest;
import com.ibm.hwmca.fw.rsf.RsfResult;
import com.ibm.hwmca.fw.rsf.RsfResultProcessor;
import com.ibm.hwmca.fw.service.managedsystem.ServiceableElement;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.util.FileUtilities;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import com.ibm.hwmca.xfw.rsf.RepairVerifyRequestBody;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class RVRetainRequestProcessor
implements RsfResultProcessor {
    private static final String TRACE_MASKT = "XRVXEOCT";
    private static final String TRACE_MASKF = "XRVXEOCF";
    private static final String TRACE_MASKD = "XRVXEOCD";
    private static String className = "com.ibm.hwmca.xfw.repair.utils.RVRetainRequestProcessor";
    private static LocalizableText desc = new LocalizableText("RVRetainRequest");

    public static void initiateRVRequest(Map userData) {
        try {
            Trace.trace(TRACE_MASKD, "RVRetainRequestProcessor: getRetainRVRetain");
            String baseRsfImplId = "com.ibm.hwmca.base.rsf.BaseRsfImpl";
            RemoteSupportFacility rsf = RsfManager.getRsfManager().getRsf(baseRsfImplId);
            if (rsf != null) {
                Trace.trace(TRACE_MASKD, "RVRetainRequestProcessor: got RemoteSupport Facility");
                RsfRequest req = rsf.newRequestInstance(RVRetainRequestProcessor.buildRequest(userData), className, desc);
                Trace.trace(TRACE_MASKD, "RVRetainRequestProcessor: got new request instance");
                req.submit();
                Trace.trace(TRACE_MASKD, "RVRetainRequestProcessor: submitted request");
            } else {
                Trace.trace(TRACE_MASKD, "RVRetainRequestProcessor: no RemoteSupport Facility");
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "RVRetainRequestProcessor Submission Error ");
            Trace.trace(TRACE_MASKF, e);
        }
    }

    static RepairVerifyRequestBody buildRequest(Map userData) {
        Trace.trace(TRACE_MASKT, "-> RVRetainRequestProcessor::buildRequest()");
        RepairVerifyRequestBody body = new RepairVerifyRequestBody();
        body.initializeMachineInformation();
        body.initializeUpdateList();
        CommonProblem p = (CommonProblem)userData.get("PROBLEM");
        String pmh = p.getPMH();
        if (pmh != null) {
            body.putAttribute("PMH NUMBER", pmh);
            body.putAttribute("Close pmh", "Y");
        } else {
            body.putAttribute("Close pmh", "N");
        }
        ArrayList<String> eocFileList = new ArrayList<String>(3);
        if (RVRetainRequestProcessor.buildEocFile(userData)) {
            String eocDataFileName = "acureoc dat";
            eocFileList.add(eocDataFileName);
        }
        if (RVRetainRequestProcessor.buildRefFile(userData)) {
            String eocRefDataFileName = "acurref dat";
            eocFileList.add(eocRefDataFileName);
        }
        if (RVRetainRequestProcessor.buildSysFile()) {
            String eocSysDataFileName = "acursys dat";
            eocFileList.add(eocSysDataFileName);
        }
        body.setFileList(eocFileList);
        Trace.trace(TRACE_MASKD, "<-RVRetainRequestProcessor::buildRequest");
        return body;
    }

    public void RVRetainRequestProcessor() {
    }

    public void rsfRequestCompleted(RsfRequest request, RsfResult result) {
        Trace.trace(TRACE_MASKT, "-> RVRetainRequestProcessor::rsfRequestCompleted()");
        try {
            RepairVerifyRequestBody body = (RepairVerifyRequestBody)request.getBody();
        }
        catch (ClassCastException e) {
            Trace.trace(TRACE_MASKF, "RVRetainRequestProcessor.rsfRequestCompleted: error casting request body");
            Trace.trace(TRACE_MASKF, e);
            return;
        }
        Trace.trace(TRACE_MASKT, " RVRetainRequestProcessor::rsfRequestCompleted() status=" + result.getStatusMessage());
    }

    static boolean buildEocFile(Map userData) {
        int i;
        DataOutputStream outputStream;
        String fileName;
        Trace.trace(TRACE_MASKT, "-> RVRetainRequestProcessor::buildEocFile()");
        try {
            fileName = BaseFileControl.getFilePath("acureoc.dat") + "acureoc.dat";
        }
        catch (HException e) {
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC data file is " + fileName);
        try {
            FileUtilities.delete(fileName);
        }
        catch (FileNotFoundException e) {
            Trace.trace(TRACE_MASKF, "EOC data file didn't exist, continue");
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException deleting file, return false");
            return false;
        }
        Trace.trace(TRACE_MASKF, "Existing EOC data file deleted OK or didn't exist");
        try {
            outputStream = new DataOutputStream(new FileOutputStream(fileName));
        }
        catch (FileNotFoundException e) {
            Trace.trace(TRACE_MASKF, "Error creating EOC data file stream, return false");
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC data file stream created OK");
        int eocVersion = 1;
        try {
            outputStream.writeShort(eocVersion);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing version,return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC version written OK");
        CommonProblem p = (CommonProblem)userData.get("PROBLEM");
        PASystem pas = p.getFailingSystem();
        String systemType = null;
        if (pas != null) {
            systemType = pas.getMachineType();
        }
        if (systemType == null) {
            systemType = "    ";
        }
        try {
            outputStream.writeBytes(systemType);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing systemType,return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC systemType written OK");
        int zeroByte = 0;
        try {
            outputStream.writeByte(zeroByte);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing systemType null terminator,return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC systemType null terminator written OK");
        String systemSerial = null;
        if (pas != null) {
            systemSerial = pas.getMachineSerial();
        }
        if (systemSerial == null) {
            systemSerial = "            ";
        }
        try {
            outputStream.writeBytes(systemSerial);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing systemSerial,return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC systemSerial written OK");
        try {
            outputStream.writeByte(zeroByte);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing systemSerial null terminator,return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC systemSerial null terminator written OK");
        String machineType = systemType;
        if (machineType == null) {
            machineType = "    ";
        }
        try {
            outputStream.writeBytes(machineType);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing machineType,return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC machineType written OK");
        try {
            outputStream.writeByte(zeroByte);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing machineType null terminator,return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC machineType null terminator written OK");
        String machineSerial = systemSerial;
        if (machineSerial == null) {
            machineSerial = "            ";
        }
        try {
            outputStream.writeBytes(machineSerial);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing machineSerial,return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC machineSerial written OK");
        try {
            outputStream.writeByte(zeroByte);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing machineSerial null terminator,return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC machineSerial null terminator written OK");
        String machineModel = null;
        if (pas != null) {
            machineModel = pas.getMachineModel();
        }
        if (machineModel == null) {
            machineModel = "   ";
        }
        try {
            outputStream.writeBytes(machineModel);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing machineModel,return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC machineModel written OK");
        try {
            outputStream.writeByte(zeroByte);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing machineModel null terminator,return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC machineModel null terminator written OK");
        Integer Pn = new Integer(p.getProblemNumber());
        String problemNumber = Pn.toString();
        if (problemNumber.length() < 8) {
            for (int i2 = problemNumber.length(); i2 < 8; ++i2) {
                problemNumber = problemNumber + " ";
            }
        }
        try {
            outputStream.writeBytes(problemNumber);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing problemNumber,return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC problemNumber written OK");
        try {
            outputStream.writeByte(zeroByte);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing problemNumber null terminator,return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC problemNumber null terminator written OK");
        UserContext userContext = UserContext.getCurrentUserContext();
        GregorianCalendar errorTod = null;
        errorTod = userContext != null ? new GregorianCalendar(userContext.getTimeZone(), userContext.getLocale()) : new GregorianCalendar();
        try {
            errorTod.setTime(((EventLog)p.getPrimaryDataEvent().getData()).getTimestamp());
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "EOC exception getting timestamp from problem, use current TOD");
            errorTod.clear();
            Date tempDate = new Date();
            errorTod.setTime(tempDate);
        }
        String errorHMSHu = "";
        Integer errorHour = new Integer(errorTod.get(11));
        if (errorHour < 10) {
            errorHMSHu = errorHMSHu + "0";
        }
        errorHMSHu = errorHMSHu + errorHour.toString();
        errorHMSHu = errorHMSHu + "::";
        Integer errorMinute = new Integer(errorTod.get(12));
        if (errorMinute < 10) {
            errorHMSHu = errorHMSHu + "0";
        }
        errorHMSHu = errorHMSHu + errorMinute.toString();
        errorHMSHu = errorHMSHu + "::";
        Integer errorSeconds = new Integer(errorTod.get(13));
        if (errorSeconds < 10) {
            errorHMSHu = errorHMSHu + "0";
        }
        errorHMSHu = errorHMSHu + errorSeconds.toString();
        errorHMSHu = errorHMSHu + "::";
        Integer errorHundreths = new Integer(errorTod.get(14) / 10);
        if (errorHundreths < 10) {
            errorHMSHu = errorHMSHu + "0";
        }
        errorHMSHu = errorHMSHu + errorHundreths.toString();
        try {
            outputStream.writeBytes(errorHMSHu);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing errorHMSHu, return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC errorHMSHu written OK");
        try {
            outputStream.writeByte(zeroByte);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing null terminator, return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC null terminator written OK");
        String errorYMD = "";
        Integer errorYear = new Integer(errorTod.get(1));
        errorYMD = errorYMD + errorYear.toString();
        errorYMD = errorYMD + "--";
        Integer errorMonth = new Integer(errorTod.get(2) + 1);
        if (errorMonth < 10) {
            errorYMD = errorYMD + "0";
        }
        errorYMD = errorYMD + errorMonth.toString();
        errorYMD = errorYMD + "--";
        Integer errorDay = new Integer(errorTod.get(5));
        if (errorDay < 10) {
            errorYMD = errorYMD + "0";
        }
        errorYMD = errorYMD + errorDay.toString();
        try {
            outputStream.writeBytes(errorYMD);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing errorYMD, return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC errorYMD written OK");
        try {
            outputStream.writeByte(zeroByte);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing null terminator, return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC null terminator written OK");
        List historyList = p.getServiceHistory().getHistory();
        HistoryEntry entry = new HistoryEntry();
        Date entryDate = new Date();
        int todYear = 0;
        byte[] todInfo = new byte[6];
        Iterator iterator = historyList.iterator();
        while (iterator.hasNext()) {
            try {
                entry = (HistoryEntry)iterator.next();
            }
            catch (NoSuchElementException e) {
                Trace.trace(TRACE_MASKF, "NoSuchElementException searching Service History list,return false");
                return false;
            }
            if (entry.getHistory() != 2) continue;
            entryDate = entry.getDate();
            todInfo = RVRetainRequestProcessor.toTodInfo(entryDate);
            todYear = RVRetainRequestProcessor.toTodInfoYear(entryDate);
            break;
        }
        try {
            outputStream.writeShort(todYear);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing reported to customer TOD year, return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC reported to customer TOD year written OK");
        try {
            outputStream.write(todInfo);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing reported to customer TOD, return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC reported to customer TOD written OK");
        todYear = 0;
        for (i = 0; i < 6; ++i) {
            todInfo[i] = 0;
        }
        iterator = historyList.iterator();
        while (iterator.hasNext()) {
            try {
                entry = (HistoryEntry)iterator.next();
            }
            catch (NoSuchElementException e) {
                Trace.trace(TRACE_MASKF, "NoSuchElementException searching Service History list,return false");
                return false;
            }
            if (entry.getHistory() != 3) continue;
            entryDate = entry.getDate();
            todInfo = RVRetainRequestProcessor.toTodInfo(entryDate);
            todYear = RVRetainRequestProcessor.toTodInfoYear(entryDate);
            break;
        }
        try {
            outputStream.writeShort(todYear);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing reported to service TOD year, return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC reported to service TOD year written OK");
        try {
            outputStream.write(todInfo);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing reported to service TOD, return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC reported to service TOD written OK");
        todYear = 0;
        for (i = 0; i < 6; ++i) {
            todInfo[i] = 0;
        }
        iterator = historyList.iterator();
        while (iterator.hasNext()) {
            try {
                entry = (HistoryEntry)iterator.next();
            }
            catch (NoSuchElementException e) {
                Trace.trace(TRACE_MASKF, "NoSuchElementException searching Service History list,return false");
                return false;
            }
            if (entry.getHistory() != 4) continue;
            entryDate = entry.getDate();
            todInfo = RVRetainRequestProcessor.toTodInfo(entryDate);
            todYear = RVRetainRequestProcessor.toTodInfoYear(entryDate);
            break;
        }
        try {
            outputStream.writeShort(todYear);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing repair started TOD year, return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC repair started TOD year written OK");
        try {
            outputStream.write(todInfo);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing repair started TOD, return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC repair started TOD written OK");
        todYear = 0;
        for (i = 0; i < 6; ++i) {
            todInfo[i] = 0;
        }
        iterator = historyList.iterator();
        while (iterator.hasNext()) {
            try {
                entry = (HistoryEntry)iterator.next();
            }
            catch (NoSuchElementException e) {
                Trace.trace(TRACE_MASKF, "NoSuchElementException searching Service History list,return false");
                return false;
            }
            if (entry.getHistory() != 5) continue;
            entryDate = entry.getDate();
            todInfo = RVRetainRequestProcessor.toTodInfo(entryDate);
            todYear = RVRetainRequestProcessor.toTodInfoYear(entryDate);
            break;
        }
        try {
            outputStream.writeShort(todYear);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing repair suspended TOD year, return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC repair suspended TOD year written OK");
        try {
            outputStream.write(todInfo);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing repair suspended TOD, return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC repair suspended TOD written OK");
        todYear = 0;
        for (i = 0; i < 6; ++i) {
            todInfo[i] = 0;
        }
        iterator = historyList.iterator();
        while (iterator.hasNext()) {
            try {
                entry = (HistoryEntry)iterator.next();
            }
            catch (NoSuchElementException e) {
                Trace.trace(TRACE_MASKF, "NoSuchElementException searching Service History list,return false");
                return false;
            }
            if (entry.getHistory() != 8) continue;
            entryDate = entry.getDate();
            todInfo = RVRetainRequestProcessor.toTodInfo(entryDate);
            todYear = RVRetainRequestProcessor.toTodInfoYear(entryDate);
            break;
        }
        try {
            outputStream.writeShort(todYear);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing repair resumed TOD year, return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC repair resumed TOD year written OK");
        try {
            outputStream.write(todInfo);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing repair resumed TOD, return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC repair resumed TOD written OK");
        todYear = 0;
        for (i = 0; i < 6; ++i) {
            todInfo[i] = 0;
        }
        iterator = historyList.iterator();
        while (iterator.hasNext()) {
            try {
                entry = (HistoryEntry)iterator.next();
            }
            catch (NoSuchElementException e) {
                Trace.trace(TRACE_MASKF, "NoSuchElementException searching Service History list,return false");
                return false;
            }
            if (entry.getHistory() != 9) continue;
            entryDate = entry.getDate();
            todInfo = RVRetainRequestProcessor.toTodInfo(entryDate);
            todYear = RVRetainRequestProcessor.toTodInfoYear(entryDate);
            break;
        }
        try {
            outputStream.writeShort(todYear);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing repair ended TOD year, return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC repair ended TOD year written OK");
        try {
            outputStream.write(todInfo);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing repair ended TOD, return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC repair ended TOD written OK");
        String refcode = p.getRefcode();
        if (refcode == null) {
            refcode = "        ";
        }
        try {
            outputStream.writeBytes(refcode);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing refcode,return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC refcode written OK");
        try {
            outputStream.writeByte(zeroByte);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing refcode null terminator,return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC refcode null terminator written OK");
        String extension = p.getExtension();
        if (extension == null) {
            extension = "        ";
        }
        try {
            outputStream.writeBytes(extension);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing extension,return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC extension written OK");
        try {
            outputStream.writeByte(zeroByte);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing extension null terminator,return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC extension null terminator written OK");
        int suspendReason = 0;
        try {
            outputStream.writeShort(suspendReason);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing suspend reason,return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC suspend reason written OK");
        String pmh = p.getPMH();
        if (pmh == null) {
            pmh = "     ";
        }
        try {
            outputStream.writeBytes(pmh);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing pmh,return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC pmh written OK");
        try {
            outputStream.writeByte(zeroByte);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing pmh null terminator,return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC pmh null terminator written OK");
        List exchangedFrus = (List)userData.get("EXCHANGED_FRUS");
        if (exchangedFrus != null) {
            Iterator partIterator = exchangedFrus.iterator();
            while (partIterator.hasNext()) {
                Map fruProps;
                try {
                    ServiceableElement.PersistentDataImpl fruPDI = (ServiceableElement.PersistentDataImpl)partIterator.next();
                    fruProps = fruPDI.properties;
                }
                catch (NoSuchElementException e) {
                    Trace.trace(TRACE_MASKF, "NoSuchElementException searching FRU list,return false");
                    return false;
                }
                try {
                    outputStream.writeBytes("M");
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing frutype, return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC frutype M written OK");
                String oldPartNumber = (String)fruProps.get("OLD_PART_NUM");
                Trace.trace(TRACE_MASKF, "EOC old part number is " + oldPartNumber);
                if (oldPartNumber == null) {
                    oldPartNumber = (String)fruProps.get("PART_NUM");
                    Trace.trace(TRACE_MASKF, "EOC part number is " + oldPartNumber);
                    if (oldPartNumber == null) {
                        oldPartNumber = "DefaultPN";
                    }
                }
                if (oldPartNumber.length() < 12) {
                    for (int i3 = oldPartNumber.length(); i3 < 12; ++i3) {
                        oldPartNumber = oldPartNumber + " ";
                    }
                }
                try {
                    outputStream.writeBytes(oldPartNumber);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing oldPartNumber,return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC oldPartNumber written OK");
                try {
                    outputStream.writeByte(zeroByte);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing oldPartNumber null terminator,return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC oldPartNumber null terminator written OK");
                String oldSerialNumber = (String)fruProps.get("OLD_SERIAL_NUM");
                if (oldSerialNumber == null) {
                    oldSerialNumber = (String)fruProps.get("SERIAL_NUM");
                    Trace.trace(TRACE_MASKF, "EOC old new serial number is " + oldSerialNumber);
                    if (oldSerialNumber == null) {
                        oldSerialNumber = "DefaultSN";
                    }
                }
                if (oldSerialNumber.length() < 12) {
                    for (int i4 = oldSerialNumber.length(); i4 < 12; ++i4) {
                        oldSerialNumber = oldSerialNumber + " ";
                    }
                }
                Trace.trace(TRACE_MASKF, "EOC old serial number is " + oldSerialNumber);
                try {
                    outputStream.writeBytes(oldSerialNumber);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing oldSerialNumber,return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC oldSerialNumber written OK");
                try {
                    outputStream.writeByte(zeroByte);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing oldSerialNumber null terminator,return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC oldSerialNumber null terminator written OK");
                String oldECNumber = (String)fruProps.get("OLD_EC_LEVEL");
                if (oldECNumber == null) {
                    oldECNumber = (String)fruProps.get("EC_LEVEL");
                    Trace.trace(TRACE_MASKF, "EOC old new EC number is " + oldECNumber);
                    if (oldECNumber == null) {
                        oldECNumber = "DefaultSN";
                    }
                }
                if (oldECNumber.length() < 12) {
                    for (int i5 = oldECNumber.length(); i5 < 12; ++i5) {
                        oldECNumber = oldECNumber + " ";
                    }
                }
                Trace.trace(TRACE_MASKF, "EOC writing EC number " + oldECNumber);
                try {
                    outputStream.writeBytes(oldECNumber);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing oldECNumber,return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC oldECNumber written OK");
                try {
                    outputStream.writeByte(zeroByte);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing oldECNumber null terminator,return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC oldECNumber null terminator written OK");
                String physicalLocation = (String)fruProps.get("LOCATION");
                if (physicalLocation.length() < 25) {
                    for (int i6 = physicalLocation.length(); i6 < 25; ++i6) {
                        physicalLocation = physicalLocation + " ";
                    }
                }
                Trace.trace(TRACE_MASKF, "EOC writing location " + physicalLocation);
                try {
                    outputStream.writeBytes(physicalLocation);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing physicalLocation,return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC physicalLocation written OK");
                try {
                    outputStream.writeByte(zeroByte);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing physicalLocation null terminator,return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC physicalLocation null terminator written OK");
                String ccin = (String)fruProps.get("CCIN");
                if (ccin == null) {
                    ccin = "    ";
                }
                if (ccin.length() < 4) {
                    for (int i7 = ccin.length(); i7 < 4; ++i7) {
                        ccin = ccin + " ";
                    }
                }
                Trace.trace(TRACE_MASKF, "EOC writing ccin " + ccin);
                try {
                    outputStream.writeBytes(ccin);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing ccin,return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC ccin written OK");
                try {
                    outputStream.writeByte(zeroByte);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing ccin null terminator,return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC ccin null terminator written OK");
                String installTod = (String)fruProps.get("INSTALL_TOD");
                if (installTod == null) {
                    installTod = " ";
                }
                if (installTod.length() < 14) {
                    for (int i8 = installTod.length(); i8 < 14; ++i8) {
                        installTod = installTod + " ";
                    }
                }
                Trace.trace(TRACE_MASKF, "EOC writing install TOD " + installTod);
                try {
                    outputStream.writeBytes(installTod);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing installTod,return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC installTod written OK");
                try {
                    outputStream.writeByte(zeroByte);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing installTod null terminator,return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC installTod null terminator written OK");
                String dummyTod = "        ";
                Trace.trace(TRACE_MASKF, "EOC writing reseat TOD " + dummyTod);
                try {
                    outputStream.writeBytes(dummyTod);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing dummyTod,return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC dummyTod written OK");
                Trace.trace(TRACE_MASKF, "EOC old FRU data OK, now process new FRU data");
                try {
                    outputStream.writeBytes("N");
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing frutype, return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC frutype N written OK");
                String newPartNumber = (String)fruProps.get("PART_NUM");
                if (newPartNumber == null) {
                    newPartNumber = " ";
                }
                if (newPartNumber.length() < 12) {
                    for (int i9 = newPartNumber.length(); i9 < 12; ++i9) {
                        newPartNumber = newPartNumber + " ";
                    }
                }
                Trace.trace(TRACE_MASKF, "EOC writing part number " + newPartNumber);
                try {
                    outputStream.writeBytes(newPartNumber);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing newPartNumber,return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC newPartNumber written OK");
                try {
                    outputStream.writeByte(zeroByte);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing newPartNumber null terminator,return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC newPartNumber null terminator written OK");
                String newSerialNumber = (String)fruProps.get("SERIAL_NUM");
                if (newSerialNumber == null) {
                    newSerialNumber = " ";
                }
                if (newSerialNumber.length() < 12) {
                    for (int i10 = newSerialNumber.length(); i10 < 12; ++i10) {
                        newSerialNumber = newSerialNumber + " ";
                    }
                }
                try {
                    outputStream.writeBytes(newSerialNumber);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing newSerialNumber,return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC newSerialNumber written OK");
                try {
                    outputStream.writeByte(zeroByte);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing newSerialNumber null terminator,return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC newSerialNumber null terminator written OK");
                String newECNumber = (String)fruProps.get("EC_LEVEL");
                if (newECNumber == null) {
                    newECNumber = " ";
                }
                if (newECNumber.length() < 12) {
                    for (int i11 = newECNumber.length(); i11 < 12; ++i11) {
                        newECNumber = newECNumber + " ";
                    }
                }
                try {
                    outputStream.writeBytes(newECNumber);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing newECNumber,return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC newECNumber written OK");
                try {
                    outputStream.writeByte(zeroByte);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing newECNumber null terminator,return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC newECNumber null terminator written OK");
                try {
                    outputStream.writeBytes(physicalLocation);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing physicalLocation,return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC physicalLocation written OK");
                try {
                    outputStream.writeByte(zeroByte);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing physicalLocation null terminator,return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC physicalLocation null terminator written OK");
                try {
                    outputStream.writeBytes(ccin);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing ccin,return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC ccin written OK");
                try {
                    outputStream.writeByte(zeroByte);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing ccin null terminator,return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC ccin null terminator written OK");
                String dummyOldTod = "             ";
                try {
                    outputStream.writeBytes(dummyOldTod);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing dummyOldTod,return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC dummyOldTod written OK");
                try {
                    outputStream.writeByte(zeroByte);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing dummyOldTod null terminator,return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC dummyOldTod null terminator written OK");
                try {
                    outputStream.writeBytes(dummyTod);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing dummyTod,return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC dummyTod written OK");
            }
        }
        try {
            outputStream.flush();
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException flushing file,return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC file flushed OK");
        try {
            outputStream.close();
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException closing file,return false");
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC file closed OK");
        return true;
    }

    static boolean buildRefFile(Map userData) {
        DataOutputStream outputStream;
        String fileName;
        int refVersion = 2;
        Date entryDate = new Date();
        short todYear = 0;
        byte[] todInfo = new byte[6];
        Date startDate = new Date();
        Trace.trace(TRACE_MASKT, "-> RVRetainRequestProcessor::buildRefFile()");
        boolean entriesFound = false;
        try {
            fileName = BaseFileControl.getFilePath("acurref.dat") + "acurref.dat";
        }
        catch (HException e) {
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC ref data file is " + fileName);
        File refFile = new File(fileName);
        boolean fileExist = false;
        if (refFile.exists()) {
            DataInputStream inputStream;
            fileExist = true;
            try {
                inputStream = new DataInputStream(new FileInputStream(fileName));
            }
            catch (FileNotFoundException e) {
                Trace.trace(TRACE_MASKF, "Error creating existing ref file stream, return false");
                return false;
            }
            Trace.trace(TRACE_MASKF, "EOC data file stream created OK");
            try {
                refVersion = inputStream.readShort();
            }
            catch (IOException e) {
                Trace.trace(TRACE_MASKF, "IOException reading ref version, return false");
                return false;
            }
            Trace.trace(TRACE_MASKF, "EOC ref version read OK");
            try {
                todYear = inputStream.readShort();
            }
            catch (IOException e) {
                Trace.trace(TRACE_MASKF, "IOException reading ref year, return false");
                return false;
            }
            Trace.trace(TRACE_MASKF, "EOC ref year read OK");
            try {
                inputStream.readFully(todInfo);
            }
            catch (IOException e) {
                Trace.trace(TRACE_MASKF, "IOException reading sys TOD, return false");
                return false;
            }
            Trace.trace(TRACE_MASKF, "EOC sys TOD read OK");
            startDate = RVRetainRequestProcessor.todInfoToDate(todInfo, todYear);
            try {
                inputStream.close();
            }
            catch (FileNotFoundException e) {
                Trace.trace(TRACE_MASKF, "FileNotFoundException closing existing ref file,return false");
                return false;
            }
            catch (IOException e) {
                Trace.trace(TRACE_MASKF, "IOException closing existing ref file,return false");
                return false;
            }
            Trace.trace(TRACE_MASKF, "EOC existing ref file closed OK");
            try {
                refFile.delete();
            }
            catch (SecurityException e) {
                Trace.trace(TRACE_MASKF, "SecurityException deleting existing ref file, return false");
                return false;
            }
        }
        try {
            outputStream = new DataOutputStream(new FileOutputStream(fileName));
        }
        catch (FileNotFoundException e) {
            Trace.trace(TRACE_MASKF, "Error creating ref file stream, return false");
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC ref file stream created OK");
        refVersion = 2;
        try {
            outputStream.writeShort(refVersion);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing ref version, return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC ref version written OK");
        todInfo = RVRetainRequestProcessor.toTodInfo(entryDate);
        todYear = RVRetainRequestProcessor.toTodInfoYear(entryDate);
        try {
            outputStream.writeShort(todYear);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing reported to customer TOD year, return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC reported to customer TOD year written OK");
        try {
            outputStream.write(todInfo);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing reported to customer TOD, return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC reported to customer TOD written OK");
        ProblemManager pm = null;
        try {
            pm = pm.getProblemManager();
        }
        catch (PersistenceNotInitializedException e) {
            Trace.trace(TRACE_MASKF, "PersistenceNotInitializedException getting problem manager, return false");
            return false;
        }
        catch (ProblemPersistenceException e) {
            Trace.trace(TRACE_MASKF, "ProblemPersistenceException getting problem manager, return false");
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC got Problem Manager OK");
        int zeroByte = 0;
        List problemList = null;
        if (fileExist) {
            TimeProblemFilter timeFilter = new TimeProblemFilter(entryDate.getTime() - startDate.getTime());
            timeFilter.filter(problemList, pm.getAllProblems());
        } else {
            problemList = pm.getAllProblems();
        }
        if (problemList != null && problemList.size() != 0) {
            Iterator iterator = problemList.iterator();
            while (iterator.hasNext()) {
                int counter;
                Problem p;
                try {
                    p = (Problem)iterator.next();
                }
                catch (NoSuchElementException e) {
                    Trace.trace(TRACE_MASKF, "NoSuchElementException processing problem list,return false");
                    return false;
                }
                if (!(p instanceof CommonProblem)) continue;
                CommonProblem cp = (CommonProblem)p;
                entriesFound = true;
                Integer pn = new Integer(cp.getProblemNumber());
                String problemNumber = pn.toString();
                if (problemNumber.length() < 8) {
                    for (int i = problemNumber.length(); i < 8; ++i) {
                        problemNumber = problemNumber + " ";
                    }
                }
                try {
                    outputStream.writeBytes(problemNumber);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing problemNumber,return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC problemNumber written OK");
                try {
                    outputStream.writeByte(zeroByte);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing problemNumber null terminator,return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC problemNumber null terminator written OK");
                String refcode = cp.getRefcode();
                if (refcode == null) {
                    refcode = "        ";
                }
                try {
                    outputStream.writeBytes(refcode);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing refcode, return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC ref refcode written OK");
                try {
                    outputStream.writeByte(zeroByte);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing refcode null terminator, return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC refcode null terminator written OK");
                String extension = cp.getExtension();
                if (extension == null) {
                    extension = "        ";
                }
                try {
                    outputStream.writeBytes(extension);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing extension,return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC extension written OK");
                try {
                    outputStream.writeByte(zeroByte);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing extension null terminator,return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC extension null terminator written OK");
                UserContext userContext = UserContext.getCurrentUserContext();
                GregorianCalendar errorTod = null;
                errorTod = userContext != null ? new GregorianCalendar(userContext.getTimeZone(), userContext.getLocale()) : new GregorianCalendar();
                try {
                    errorTod.setTime(((EventLog)cp.getPrimaryDataEvent().getData()).getTimestamp());
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "EOC exception getting timestamp from problem, use current TOD");
                    errorTod.clear();
                    Date tempDate = new Date();
                    errorTod.setTime(tempDate);
                }
                String errorYMD = "";
                Integer errorYear = new Integer(errorTod.get(1));
                errorYMD = errorYMD + errorYear.toString();
                errorYMD = errorYMD + "-";
                Integer errorMonth = new Integer(errorTod.get(2) + 1);
                if (errorMonth < 10) {
                    errorYMD = errorYMD + "0";
                }
                errorYMD = errorYMD + errorMonth.toString();
                errorYMD = errorYMD + "-";
                Integer errorDay = new Integer(errorTod.get(5));
                if (errorDay < 10) {
                    errorYMD = errorYMD + "0";
                }
                errorYMD = errorYMD + errorDay.toString();
                try {
                    outputStream.writeBytes(errorYMD);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing errorYMD, return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC errorYMD written OK");
                for (int counter2 = 0; counter2 < 3; ++counter2) {
                    try {
                        outputStream.writeByte(zeroByte);
                        continue;
                    }
                    catch (IOException e) {
                        Trace.trace(TRACE_MASKF, "IOException writing null terminator, return false");
                        try {
                            outputStream.close();
                        }
                        catch (IOException ee) {
                            return false;
                        }
                        return false;
                    }
                }
                Trace.trace(TRACE_MASKF, "EOC null terminator written OK");
                String errorHMSHu = "";
                Integer errorHour = new Integer(errorTod.get(11));
                if (errorHour < 10) {
                    errorHMSHu = errorHMSHu + "0";
                }
                errorHMSHu = errorHMSHu + errorHour.toString();
                errorHMSHu = errorHMSHu + ":";
                Integer errorMinute = new Integer(errorTod.get(12));
                if (errorMinute < 10) {
                    errorHMSHu = errorHMSHu + "0";
                }
                errorHMSHu = errorHMSHu + errorMinute.toString();
                errorHMSHu = errorHMSHu + ":";
                Integer errorSeconds = new Integer(errorTod.get(13));
                if (errorSeconds < 10) {
                    errorHMSHu = errorHMSHu + "0";
                }
                errorHMSHu = errorHMSHu + errorSeconds.toString();
                errorHMSHu = errorHMSHu + ":";
                Integer errorHundreths = new Integer(errorTod.get(14) / 10);
                if (errorHundreths < 10) {
                    errorHMSHu = errorHMSHu + "0";
                }
                errorHMSHu = errorHMSHu + errorHundreths.toString();
                try {
                    outputStream.writeBytes(errorHMSHu);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing errorHMSHu, return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC errorHMSHu written OK");
                for (counter = 0; counter < 4; ++counter) {
                    try {
                        outputStream.writeByte(zeroByte);
                        continue;
                    }
                    catch (IOException e) {
                        Trace.trace(TRACE_MASKF, "IOException writing null terminator, return false");
                        try {
                            outputStream.close();
                        }
                        catch (IOException ee) {
                            return false;
                        }
                        return false;
                    }
                }
                Trace.trace(TRACE_MASKF, "EOC null terminator written OK");
                try {
                    outputStream.writeBytes("00");
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing status, return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                try {
                    outputStream.writeByte(zeroByte);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing null terminator, return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC null terminator written OK");
                for (counter = 0; counter < 4; ++counter) {
                    try {
                        outputStream.writeByte(zeroByte);
                        continue;
                    }
                    catch (IOException e) {
                        Trace.trace(TRACE_MASKF, "IOException writing null terminator, return false");
                        try {
                            outputStream.close();
                        }
                        catch (IOException ee) {
                            return false;
                        }
                        return false;
                    }
                }
                Trace.trace(TRACE_MASKF, "EOC null terminator written OK");
            }
        }
        try {
            outputStream.flush();
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException flushing ref file,return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC ref file flushed OK");
        try {
            outputStream.close();
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException closing ref file,return false");
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC ref file closed OK");
        return entriesFound;
    }

    static boolean buildSysFile() {
        Log[] retrievedLogs;
        DataOutputStream outputStream;
        String fileName;
        Trace.trace(TRACE_MASKT, "-> RVRetainRequestProcessor::buildSysFile()");
        boolean entriesFound = false;
        int zeroByte = 0;
        Date entryDate = new Date();
        Date startDate = new Date();
        short todYear = 0;
        byte[] todInfo = new byte[6];
        short sysVersion = 1;
        try {
            fileName = BaseFileControl.getFilePath("acursys.dat") + "acursys.dat";
        }
        catch (HException e) {
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC sys data file is " + fileName);
        File sysFile = new File(fileName);
        boolean fileExist = false;
        if (sysFile.exists()) {
            DataInputStream inputStream;
            fileExist = true;
            try {
                inputStream = new DataInputStream(new FileInputStream(fileName));
            }
            catch (FileNotFoundException e) {
                Trace.trace(TRACE_MASKF, "Error creating existing sys file stream, return false");
                return false;
            }
            Trace.trace(TRACE_MASKF, "EOC data file stream created OK");
            try {
                sysVersion = inputStream.readShort();
            }
            catch (IOException e) {
                Trace.trace(TRACE_MASKF, "IOException reading sys version, return false");
                return false;
            }
            Trace.trace(TRACE_MASKF, "EOC sys version read OK");
            try {
                todYear = inputStream.readShort();
            }
            catch (IOException e) {
                Trace.trace(TRACE_MASKF, "IOException reading sys year, return false");
                return false;
            }
            Trace.trace(TRACE_MASKF, "EOC sys year read OK");
            try {
                inputStream.readFully(todInfo);
            }
            catch (IOException e) {
                Trace.trace(TRACE_MASKF, "IOException reading sys TOD, return false");
                return false;
            }
            Trace.trace(TRACE_MASKF, "EOC sys TOD read OK");
            startDate = RVRetainRequestProcessor.todInfoToDate(todInfo, todYear);
            try {
                inputStream.close();
            }
            catch (FileNotFoundException e) {
                Trace.trace(TRACE_MASKF, "FileNotFoundException closing existing sys file,return false");
                return false;
            }
            catch (IOException e) {
                Trace.trace(TRACE_MASKF, "IOException closing existing sys file,return false");
                return false;
            }
            Trace.trace(TRACE_MASKF, "EOC existing sys file closed OK");
            try {
                sysFile.delete();
            }
            catch (SecurityException e) {
                Trace.trace(TRACE_MASKF, "SecurityException deleting existing sys file, return false");
                return false;
            }
        }
        try {
            outputStream = new DataOutputStream(new FileOutputStream(fileName));
        }
        catch (FileNotFoundException e) {
            Trace.trace(TRACE_MASKF, "Error creating sys file stream, return false");
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC sys file stream created OK");
        sysVersion = 1;
        try {
            outputStream.writeShort(sysVersion);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing sys version, return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC sys version written OK");
        entryDate.getTime();
        todInfo = RVRetainRequestProcessor.toTodInfo(entryDate);
        todYear = RVRetainRequestProcessor.toTodInfoYear(entryDate);
        try {
            outputStream.writeShort(todYear);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing sys year, return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC sys year written OK");
        try {
            outputStream.write(todInfo);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing sys TOD, return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC sys TOD written OK");
        try {
            retrievedLogs = fileExist ? Log.retrieve(new Byte(0), null, null, startDate, null, null, null, null) : Log.retrieve(new Byte(0), null, null, null, null, null, null, null);
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKF, "HException retriving system events, return false");
            return false;
        }
        for (int counter = retrievedLogs.length - 1; counter >= 0; --counter) {
            int i;
            entriesFound = true;
            for (i = 0; i < 4; ++i) {
                try {
                    outputStream.writeByte(zeroByte);
                    continue;
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing null terminator, return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
            }
            Trace.trace(TRACE_MASKF, "EOC null terminator written OK");
            entryDate = retrievedLogs[counter].getTimestamp();
            todInfo = RVRetainRequestProcessor.toTodInfo(entryDate);
            todYear = RVRetainRequestProcessor.toTodInfoYear(entryDate);
            try {
                outputStream.writeShort(todYear);
            }
            catch (IOException e) {
                Trace.trace(TRACE_MASKF, "IOException writing sysevent year, return false");
                try {
                    outputStream.close();
                }
                catch (IOException ee) {
                    return false;
                }
                return false;
            }
            Trace.trace(TRACE_MASKF, "EOC sysevent year written OK");
            try {
                outputStream.write(todInfo);
            }
            catch (IOException e) {
                Trace.trace(TRACE_MASKF, "IOException writing sysevent TOD, return false");
                try {
                    outputStream.close();
                }
                catch (IOException ee) {
                    return false;
                }
                return false;
            }
            Trace.trace(TRACE_MASKF, "EOC sysevent TOD written OK");
            try {
                outputStream.writeByte(zeroByte);
            }
            catch (IOException e) {
                Trace.trace(TRACE_MASKF, "IOException writing sys count, return false");
                try {
                    outputStream.close();
                }
                catch (IOException ee) {
                    return false;
                }
                return false;
            }
            Trace.trace(TRACE_MASKF, "EOC sys count written OK");
            String entryText = retrievedLogs[counter].getEventName();
            try {
                outputStream.writeBytes(entryText);
            }
            catch (IOException e) {
                Trace.trace(TRACE_MASKF, "IOException writing entryText, return false");
                try {
                    outputStream.close();
                }
                catch (IOException ee) {
                    return false;
                }
                return false;
            }
            Trace.trace(TRACE_MASKF, "EOC entryText written OK");
            for (i = entryText.length(); i < 12; ++i) {
                try {
                    outputStream.writeByte(zeroByte);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing extra nulls, return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC extra null written OK");
            }
        }
        try {
            outputStream.flush();
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException flushing sys file,return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC sys file flushed OK");
        try {
            outputStream.close();
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException closing sys file,return false");
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC ref file closed OK");
        return entriesFound;
    }

    private static byte[] toTodInfo(Date entryDate) {
        byte[] todInfo = new byte[6];
        UserContext userContext = UserContext.getCurrentUserContext();
        GregorianCalendar entryTod = null;
        entryTod = userContext != null ? new GregorianCalendar(userContext.getTimeZone(), userContext.getLocale()) : new GregorianCalendar();
        entryTod.setTime(entryDate);
        todInfo[0] = (byte)entryTod.get(2);
        todInfo[1] = (byte)entryTod.get(5);
        todInfo[2] = (byte)entryTod.get(11);
        todInfo[3] = (byte)entryTod.get(12);
        todInfo[4] = (byte)entryTod.get(13);
        int entryMilli = entryTod.get(14);
        todInfo[5] = (byte)(entryMilli / 10);
        return todInfo;
    }

    private static short toTodInfoYear(Date entryDate) {
        UserContext userContext = UserContext.getCurrentUserContext();
        GregorianCalendar entryTod = null;
        entryTod = userContext != null ? new GregorianCalendar(userContext.getTimeZone(), userContext.getLocale()) : new GregorianCalendar();
        entryTod.setTime(entryDate);
        short entryYear = (short)entryTod.get(1);
        return entryYear;
    }

    private static Date todInfoToDate(byte[] todInfo, short entryYear) {
        UserContext userContext = UserContext.getCurrentUserContext();
        GregorianCalendar entryTod = null;
        entryTod = userContext != null ? new GregorianCalendar(userContext.getTimeZone(), userContext.getLocale()) : new GregorianCalendar();
        entryTod.set(1, entryYear);
        entryTod.set(2, todInfo[0]);
        entryTod.set(5, todInfo[1]);
        entryTod.set(11, todInfo[2]);
        entryTod.set(12, todInfo[3]);
        entryTod.set(13, todInfo[4]);
        entryTod.set(14, 10 * todInfo[5]);
        return entryTod.getTime();
    }
}

